###############################################################################
 # Copyright (c) 2012, Moitrayee Bhattacharyya, Kallol Gupta, P. Balaram, Indian Institute of Science, Bangalore, India
 # All rights reserved.
 # 
 # Redistribution and use in source and binary forms, with or without
 # modification are permitted provided that the following conditions are met:
 # 
 # (1) Redistributions of source code must retain the above copyright notice,
 # this list of conditions and the following disclaimer.
 # (2) Redistributions in binary form must reproduce the above copyright notice,
 # this list of conditions and the following disclaimer in the documentation
 # and/or other materials provided with the distribution.
 # (3) Neither the name of the Indian Institute of Science, Bangalore, India
 # nor the names of its contributors may be used to endorse or promote products 
 # derived from this software without specific prior written permission.
 #  
 # THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 # AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 # ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 # LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 # CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 # SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 # BUSINESSINTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 # IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 # ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 # POSSIBILITY OF SUCH DAMAGE.
 ##############################################################################


use strict;
use warnings;

my %pep_frag=(); my %pep_mass=(); my %pep_cys=(); my $line1; my $line2; my $i=0; my $j; my $k; my $sum=0; my $tot_mass=0;

open(W1,">pep_comb_MS");
open (Read1, "pep_cys.out") or die $!;
my @hold1=<Read1>;
close(Read1);
open (Read2, "comb_MS") or die $!;
my @hold2=<Read2>;
close(Read2);

foreach $line1 (@hold1) 
{	
	$line1=~s/\n//g;
	my @pep_ele=split('\t',$line1);
	$pep_frag{$i}=$pep_ele[0];
	$pep_mass{$i}=$pep_ele[1];
	$pep_cys{$i}=$pep_ele[2];
	$i++;
}
foreach $line2 (@hold2)
{
	$line2=~s/\n//g;
	$line2=~s/A/ /g;
	my @comb_ele=split(' ',$line2);
	my $comb_len=@comb_ele;
#	if ($comb_len == 1)
#	{
#		my $a=$comb_ele[0];
#		print W1 "$pep_frag{$a}	$pep_mass{$a}	$pep_cys{$a}\n";
#	}
#	else
#	{
	my @array1=();
	for($k=0;$k<$comb_len;$k++)
	{
		my $a=$comb_ele[$k];
		#print $comb_ele[$k],"\n";
		$sum=$sum+$pep_cys{$a};
		$tot_mass=$tot_mass+$pep_mass{$a};
		push(@array1,$pep_frag{$a});
	}
	my $tot_frag=join(' | ',@array1);
	$tot_mass=$tot_mass+1;
	my $sum1=$sum % 2;
	if ($sum1 == 0)
	{
		print W1 "$tot_frag	$tot_mass	$sum\n";
	}
	$sum=0;
	$tot_mass=0;
#	}
}
close(W1);

readpipe("copy pep_comb_MS+pep_nocys.out match_MS.inp");



